/* Copyright (C) 2011-2018 RealVNC Ltd. All Rights Reserved.
 *
 * This is sample code intended to demonstrate part of the
 * VNC Mobile Solution SDK. It is not intended as a production-ready
 * component.
 */

#include <assert.h>
#include <errno.h>
#include <stdio.h>
#include <sys/time.h>

#include <Event.h>
#include <DiscoveryException.h>

#ifdef __APPLE__
#include <sys/time.h>
#endif

// MOB-14299: Check added here since this is a common component.
#ifdef __OPTIMIZE__
#error Optimisation erroneously enabled
#endif

using namespace vncdiscovery;

Event::Event(bool manualReset, bool initiallySet)
  : mManualReset(manualReset),
    mSignalled(initiallySet)
{
}

Event::~Event()
{
}

void Event::set()
{
  vnccommon::Mutex::Locker locker(mMutex);
  mSignalled = true;
  mConditionVariable.signal();
}

void Event::wait()
{
  vnccommon::Mutex::Locker locker(mMutex);

  if(!mSignalled)
  {
    mConditionVariable.wait(locker);
  }

  if(!mManualReset)
    mSignalled = false;
}

bool Event::wait(int timeoutMs)
{
  vnccommon::Mutex::Locker locker(mMutex);
  bool result = true;

  if (!mSignalled)
  {
    result = mConditionVariable.waitWithTimeout(locker,
                                                vnccommon::Duration(timeoutMs));
  }

  if(result && !mManualReset)
    mSignalled = false;

  return result;
}

void Event::reset()
{
  vnccommon::Mutex::Locker locker(mMutex);
  mSignalled = false;
}

